/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	Header File for Constraints Convenience Functions.

#pragma once

HRESULT __declspec(dllexport) MakeParallel(ISet *objSet) ;

HRESULT __declspec(dllexport) MakePerpendicular(ILine *line1, ILine *line2) ;

HRESULT __declspec(dllexport) MakeColinear(ISet *objSet) ;

HRESULT __declspec(dllexport) MakeTangentLineCircle(ILine *line1, ILine *circle1) ;

HRESULT __declspec(dllexport) MakeTangentCircleCircle(ILine *circle1, ILine *circle2) ;

HRESULT __declspec(dllexport) MakeConcentric(ISet *objSet) ;

HRESULT __declspec(dllexport) MakeEqualLength(ISet *objSet) ;

HRESULT __declspec(dllexport) MakeEqualRadius(ISet *objSet) ;

HRESULT __declspec(dllexport) FixLine(ISet *objSet) ;

HRESULT __declspec(dllexport) ConstrainSize(ILine *line) ;

HRESULT __declspec(dllexport) ConstrainSeparationPointToPoint(IPoint *point1, IPoint *point2) ;

HRESULT __declspec(dllexport) ConstrainSeparationPointToLine(IPoint *point1, ILine *line1) ;

HRESULT __declspec(dllexport) ConstrainSeparationLineToLine(ILine *line1, ILine *line2) ;

HRESULT __declspec(dllexport) MakeRadialDim(ILine *circle1) ;

HRESULT __declspec(dllexport) MakeAngularDim(ILine *line1, ILine *line2) ;

HRESULT __declspec(dllexport) RemoveConstraints(IObjectOrSet *objSet, long nature) ;

HRESULT __declspec(dllexport) RemoveImplicit(ISet *objectSet1, ISet **objectSet2) ;

